<?php
/*
* date last modified 03-10-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - manage_staff.html.php
* Mysql Tables - tbl_admin, tbl_purchase_order, tbl_admin_type
*/
require_once('./includes/functions.php'); # general functions

$totalTaskCommission = 0;
$totalTaskAmount = 0;
$totalSalary = 0;
$totalTechPaid = 0;
$totalShopPaid = 0;
$otherExpenses = 0;
$pageMsg = '';

if(isset($_POST['search'])) {
	
	if(isset($_POST['date_to']) && strlen($_POST['date_to'])>0) {
		$to_date = trim($_POST['date_to']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$to_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $to_date);
			$to_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
	} else {
		$error = 'Please select to date';
	}

	if(isset($_POST['from_date']) && strlen($_POST['from_date'])>0) {
		$from_date = trim($_POST['from_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$from_date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $from_date);
			$from_date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}
	} else {
		$error = 'Please select from date';
	}

	if(empty($error)){

		//get total profit from tasks as commission		
		$taskCommissionRec = mysqli_fetch_array(mysqli_query($con, "SELECT sum(admin_fee) AS admin_fee FROM tbl_technician_payments WHERE status = 'paid' AND DATE(date) BETWEEN '".$from_date."' AND '".$to_date."'"));
		$totalTaskCommission = $taskCommissionRec['admin_fee'];
		
		//get total profit from tasks as task amount from staff technicians
		$taskAmountRec = mysqli_fetch_array(mysqli_query($con, "SELECT sum(user_amount) AS user_amount FROM tbl_technician_payments WHERE technician_id IN (SELECT id FROM tbl_technician WHERE type = 'own') AND status = 'paid' AND DATE(date) BETWEEN '".$from_date."' AND '".$to_date."'"));
		$totalTaskAmount = $taskAmountRec['user_amount'];
		
		//get total amount as mark paid from technicians
		$totalTechPaidRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(amount) AS amount FROM tbl_incomes WHERE cat_id = '2' AND inc_date BETWEEN '".$from_date."' AND '".$to_date."'"));
		$totalTechPaid = $totalTechPaidRec['amount'];
		
		//get total amount as mark paid from shops
		$totalShopPaidRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(amount) AS amount FROM tbl_incomes WHERE cat_id = '3' AND inc_date BETWEEN '".$from_date."' AND '".$to_date."'"));
		$totalShopPaid = $totalShopPaidRec['amount'];
		
		//get total expense as salary to staff
		$salarayRec = mysqli_fetch_array(mysqli_query($con, "SELECT sum(gross_salary) AS salary FROM tbl_staff_salary WHERE salary_date BETWEEN '".$from_date."' AND '".$to_date."'"));
		$totalSalary = $salarayRec['salary'];
		
		//get extra credits to tech as expense
		$totExtraCredits = 0;
		$adminExtraCreditRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(amount) AS amount FROM tbl_admin_tech_extra_payments WHERE DATE(date) BETWEEN '".$from_date."' AND '".$to_date."'"));
		$totExtraCredits = $adminExtraCreditRec['amount'];
		
		//get extra credits to user as expense
		$totExtraUserCredits = 0;		
		$adminExtraUserCreditRec = mysqli_fetch_array(mysqli_query($con, "SELECT SUM(amount) AS amount FROM tbl_user_payments WHERE payment_method = 'Admin' AND DATE(added_date) BETWEEN '".$from_date."' AND '".$to_date."'"));
		$totExtraUserCredits = $adminExtraUserCreditRec['amount'];
		
		//get other expenses from expense table
		$expRec = mysqli_fetch_array(mysqli_query($con, "SELECT sum(amount) AS amount FROM tbl_expenses WHERE exp_date BETWEEN '".$from_date."' AND '".$to_date."'"));
		$otherExpenses = $expRec['amount'];
		
		$totalBalance = ($totalTaskAmount+$totalTaskCommission+$totalTechPaid+$totalShopPaid)-($totalSalary+$otherExpenses+$totExtraCredits+$totExtraUserCredits);
	
	}

} else {
	$pageMsg = 'Search with from and to dates to get profit /loss';
}

?>