<?php 
require_once('includes/functions.php');

$debug = TRUE;
$curDate = date('Y-m-d');

//total user count
$userRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_user WHERE status != 'Deleted'"));
$totalUserCount  = $userRec['count'];

//total technician count
$techRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_technician WHERE status != 'Deleted'"));
$totalTechCount  = $techRec['count'];

//total tasks count
$taskRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job"));
$totalTaskCount  = $taskRec['count'];

// todays app orders
$exec_app_orders = mysqli_num_rows(mysqli_query($con, 'SELECT * FROM `tbl_job` WHERE `source`="app" AND date(date)="'.$curDate.'"'));

//get data for graph
$curMonth = date('m');
$monthCountArray = array();
for($monthCount = 0; $monthCount<$curMonth; $monthCount++){
	//get total task count on each month
	$graphTaskRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM `tbl_job` WHERE MONTH(`date`) = '".$monthCount."'"));
	$monthCountArray[] = $graphTaskRec['count'];
}
$taskGraphString = implode(',', $monthCountArray);


//get total tasks and projects count
$graphTaskRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE is_project = 'no'"));
$graphTotTasks = $graphTaskRec['count'];
$graphProjectRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE is_project = 'yes'"));
$graphTotProjects = $graphProjectRec['count'];

//get all recent assigned tasks 
$recentTaskRs = mysqli_query($con, "SELECT id, is_project, user_id, technician_id, status FROM tbl_job WHERE technician_id>0 AND technician_id IN (SELECT id FROM tbl_technician WHERE status != 'Deleted') AND user_id IN (SELECT id FROM tbl_user WHERE status != 'Deleted') ORDER BY id DESC LIMIT 5");

//get recent new tasks
$newTaskRs = mysqli_query($con, "SELECT id, is_project, user_id, task_date, task_time FROM tbl_job WHERE status = 'New' ORDER BY id DESC LIMIT 7");

//get recent new users
$newUserRs = mysqli_query($con, "SELECT id, name, email, phone, place, date FROM tbl_user WHERE status != 'Deleted' ORDER BY id DESC LIMIT 7");

//get recent new technicians
$newTechRs = mysqli_query($con, "SELECT id, name, date FROM tbl_technician WHERE viewed != 'yes' ORDER BY id DESC LIMIT 7");

//get recent new shops
$newPartnerRs = mysqli_query($con, "SELECT id, building_name, date FROM tbl_purchase_partner WHERE viewed != 'yes' ORDER BY id DESC LIMIT 7");

//get recent payments from user
$paymentsRs = mysqli_query($con, "SELECT id, technician_id, user_id, job_id, task_amount, discount_amount, admin_discount, status, date FROM tbl_technician_payments WHERE task_amount>0 ORDER BY id DESC LIMIT 10");

//get total orders on current date
$totalOrderTodayRec = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(id) AS count FROM `tbl_job` WHERE task_date = '".$curDate."'"));

$totalOrderTodayDeliveredRec = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(id) AS count FROM `tbl_job` WHERE task_date = '".$curDate."' AND status = 'paid'"));

$totalOrderTodayPendingRec = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(id) AS count FROM `tbl_job` WHERE task_date = '".$curDate."' AND status != 'paid'"));

//$totalOrderUnassignedRec = mysqli_fetch_array(mysqli_query($con, "SELECT COUNT(id) AS count FROM `tbl_job` WHERE now = 'yes' AND status = 'New'"));
if($_SERVER['REMOTE_ADDR']=='202.88.237.77'){
	//echo "SELECT COUNT(id) AS count FROM `tbl_job` WHERE task_date = '".$curDate."'";
}


?>