<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_designation, tbl_staff
*/
include('includes/functions.php'); # general functions
$advanceAmount = 0;

$staffRs = mysqli_query($con, "SELECT id, name FROM tbl_staff WHERE status = 'Active' ORDER BY name");

if(isset($_REQUEST['staff_id']) && $_REQUEST['staff_id']!=''){	
	$staffId = mysqli_real_escape_string($con, trim($_REQUEST['staff_id']));	
} else {
	header('Location:index.php?page=manage_staff');
	exit();
}


if(isset($_REQUEST['id']) && $_REQUEST['id']!=''){
	$editId = trim($_REQUEST['id']);
	$editRs = mysqli_query($con, "SELECT * FROM tbl_staff_leaves WHERE id = '".$editId."'");
	if(mysqli_num_rows($editRs)>0){
		$editRec = mysqli_fetch_array($editRs);
		$staffId = $editRec['staff_id'];
	}
}

if(isset($_POST['add'])) {
	
	if(isset($_POST['minute']) && strlen($_POST['minute'])>0) {
		$minute = trim($_POST['minute']);
	} else {
		$minute = 0;
	}
			
	if(isset($_POST['hour']) && strlen($_POST['hour'])>0) {
		$hour = trim($_POST['hour']);
	} else {
		$hour = 0;
	}
	
	if(isset($_POST['date']) && strlen($_POST['date'])>0) {
		$date = trim($_POST['date']);
	} else {
		$error = 'Please select date';
	}
	
	if(isset($_POST['staff']) && strlen($_POST['staff'])>0) {
		$staffId = trim($_POST['staff']);
	} else {
		$error = 'Please select a staff';
	}	
	
	if(empty($error)) {
		
		if($hour==0 && $minute==0){
			$error = 'Please select hour or minute';
		}
		
		if(empty($error)) {
		
			if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
			    //ok - yyy-mm-dd
			} else {
			    $dateArr = explode('-', $date);
				$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
			}					
			
			//check if already added for this staff
			$chkRs = mysqli_query($con, "SELECT id FROM tbl_staff_overtime WHERE staff_id = '".$staffId."' AND date = '".$date."'");
			if(mysqli_num_rows($chkRs)>0){
				$error = 'Overtime already added for the staff on the date!';
			}
			
			$curDate = date('Y-m-d H:i:s');
			
			if(empty($error)) {
				$insertQry = "INSERT INTO tbl_staff_overtime(staff_id, date, hour, minute, added_by, added_on) VALUES (
				'".mysqli_real_escape_string($con, $staffId)."',
				 '".$date."',
				 '".mysqli_real_escape_string($con, $hour)."',
				 '".mysqli_real_escape_string($con, $minute)."',
				 '".$_SESSION['adminId']."',				 
				 '".$curDate."')";
				
				$execInsert = mysqli_query($con,$insertQry);
				$insert_id = mysqli_insert_id($con);		
				
				if($execInsert) {					
					$success = 'Overtime Added Successfully';
					if(isset($_GET['staff_id']) && $_GET['staff_id']!=''){
						//went from manage staff page. so return back to there
						header('Location:index.php?page=manage_staff&success='.$success);
						exit();
					} else {
						if(isset($_GET['p']) && $_GET['p']!=''){
							$p = $_GET['p'];
							//went from leave report page. so return back to there
							header('Location:index.php?page=overtime_report&p='.$p.'&success='.$success);
							exit();
						} else {						
							header('Location:index.php?page=add_overtime&staff_id='.$staffId.'&success='.$success);
							exit();
						}						
					}								
				}			
			}
		
		}	
						
	} 
}



if(isset($_POST['update'])) {
	
	if(isset($_POST['minute']) && strlen($_POST['minute'])>0) {
		$minute = trim($_POST['minute']);
	} else {
		$minute = 0;
	}
			
	if(isset($_POST['hour']) && strlen($_POST['hour'])>0) {
		$hour = trim($_POST['hour']);
	} else {
		$hour = 0;
	}
	
	if(isset($_POST['date']) && strlen($_POST['date'])>0) {
		$date = trim($_POST['date']);
	} else {
		$error = 'Please select date';
	}
	
	if(isset($_POST['staff']) && strlen($_POST['staff'])>0) {
		$staffId = trim($_POST['staff']);
	} else {
		$error = 'Please select a staff';
	}
	
	if(empty($error)) {
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$date)) {
		    //ok - yyy-mm-dd
		} else {
		    $dateArr = explode('-', $date);
			$date = $dateArr[2].'-'.$dateArr[1].'-'.$dateArr[0];
		}	
				
		$lastUpdatedBy = $_SESSION['adminId'];
		
		if(empty($error)) {
			
			if($hour==0 && $minute==0){
				$error = 'Please select hour or minute';
			}
			
			if(empty($error)) {
				
				$curDate = date('Y-m-d H:i:s');
						
				$update = mysqli_query($con, "UPDATE tbl_staff_overtime SET staff_id = '".$staffId."', 
				date = '".$date."',
				hour = '".mysqli_real_escape_string($con, $hour)."',
				minute = '".mysqli_real_escape_string($con, $minute)."',				
				updated_by = '".$lastUpdatedBy."',
				updated_date = '".$curDate."' WHERE id = '".$editId."'");
								
				if($update) {					
					$success = 'Overtime Updated Successfully';
					if(isset($_GET['staff_id']) && $_GET['staff_id']!=''){
						header('Location:index.php?page=manage_staff&success='.$success);
						exit();
					} else {
						if(isset($_GET['p']) && $_GET['p']!=''){
							$p = $_GET['p'];
							//went from leave report page. so return back to there
							header('Location:index.php?page=overtime_report&p='.$p.'&success='.$success);
							exit();
						} else {						
							header('Location:index.php?page=add_overtime&staff_id='.$staffId.'&success='.$success);
							exit();
						}					
					}						
				}
			
		}
			
		}	
						
	} 
}



?>