<?php
/*
* date last modified 28-11-2017
* Edited by PI-Digi Logical Solutions
* HTML Files - add_user.html.php
* Mysql Tables - tbl_designation, tbl_staff
*/
include('includes/imgFunctions.php');
include('includes/functions.php'); # general functions

$isEdit = FALSE;
$debug = true;
$curDate = date('Y-m-d H:i:s');

if(isset($_REQUEST['p'])){
	$p = trim($_REQUEST['p']);
} else {
	$p = 1;
}

$catRs = mysqli_query($con, "SELECT id, name FROM tbl_income_category ORDER BY name");


if(isset($_REQUEST['id']) && $_REQUEST['id']!=''){
	
	$isEdit = TRUE;
	$editId = mysqli_real_escape_string($con, trim($_REQUEST['id']));	
	$editRs = mysqli_query($con, "SELECT * FROM tbl_incomes WHERE id = '".$editId."'");
	if(mysqli_num_rows($editRs)>0){
		$resEdit = mysqli_fetch_array($editRs);
	} else {
		$error = 'The record does not exist!';
	}

} 

if(isset($_POST['add'])) {
	
	if(isset($_POST['inc_date']) && strlen($_POST['inc_date'])>0) {
		$inc_date = trim($_POST['inc_date']);
	} else {
		$error = 'Please select income date';
	}
		
	if(strlen(trim($_POST['amount'])) > 0) {
		$amount = trim($_POST['amount']);
		if(is_numeric($amount) && $amount>0){
			//ok
		} else {
			$error = 'Amount should be a numeric value';
		}
	} else {
		$amount = 0;
	}
	
	if(isset($_POST['category']) && strlen($_POST['category'])>0) {
		$category = trim($_POST['category']);
	} else {
		$error = 'Please select income category';
	}	
		
	if(empty($error)) {
			
		$curDate = date('Y-m-d H:i:s');
		$adminId = $_SESSION['adminId'];
			
		$insertQry = "INSERT INTO tbl_incomes(cat_id, amount, inc_date, date, added_by) VALUES (
		'".mysqli_real_escape_string($con, $category)."',
		 '".mysqli_real_escape_string($con, $amount)."',
		 '".mysqli_real_escape_string($con, $inc_date)."',
		 '".$curDate."',
		 '".$adminId."')";
		
		$execInsert = mysqli_query($con,$insertQry);
			
		if($execInsert) {					
			$success = 'Income Added Successfully';
			header('Location:index.php?page=manage_incomes&success='.$success);
			exit();			
		}				
	} 
}

if(isset($_POST['update'])) {
	
	if(isset($_POST['inc_date']) && strlen($_POST['inc_date'])>0) {
		$inc_date = trim($_POST['inc_date']);
		if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$inc_date)) {
		   //ok
		} else {
		    $endArr = explode('-', $inc_date);
			$inc_date = $endArr[2].'-'.$endArr[1].'-'.$endArr[0];
		}
	} else {
		$error = 'Please select income date';
	}
		
	if(strlen(trim($_POST['amount'])) > 0) {
		$amount = trim($_POST['amount']);
		if(is_numeric($amount) && $amount>0){
			//ok
		} else {
			$error = 'Amount should be a numeric value';
		}
	} else {
		$amount = 0;
	}
	
	if(isset($_POST['category']) && strlen($_POST['category'])>0) {
		$category = trim($_POST['category']);
	} else {
		$error = 'Please select income category';
	}		
	
	
	if(empty($error)) {
		
		$curDate = date('Y-m-d H:i:s');		
		$adminId = $_SESSION['adminId'];			
			
		$updateQry = "UPDATE tbl_incomes SET cat_id = '".$category."', amount = '".$amount."', inc_date = '".$inc_date."', updated_by = '".$adminId."', updated_on = '".$curDate."'  WHERE id = '".$editId."'";
		$execUpdate = mysqli_query($con,$updateQry);			
		
		if($execUpdate) {
			$success = 'Income Updated Successfully';
			header('Location:index.php?page=manage_incomes&p='.$p.'&success='.$success);
			exit();			
		}				
	} 
}

?>