function show_geo_div() {
	if($('.geo-alert-div').css('display') == 'none') {
		$('.geo-alert-div').show();
		if($('.audio-alert-div').css('display') == 'block') {
			$('.audio-alert-div').hide();
			$('#audio_alert').attr('checked', false);
		}
	} else {
		$('.geo-alert-div').hide();
	}
}

function show_audio_div() {
	if($('.audio-alert-div').css('display') == 'none') {
		$('.audio-alert-div').show();
		if($('.geo-alert-div').css('display') == 'block') {
			$('.geo-alert-div').hide();			
			$('#geo_alert').attr('checked', false);
		}
	} else {
		$('.audio-alert-div').hide();
	}
}

function get_val() {	
	$('#range_val').html($('#range-1a').val()+" Meters");
	$('#geo_range').val($('#range-1a').val());
	if($('#geo_fixed_point_address')!=null) {
		var address = $('#geo_fixed_point_address').val();
		var lat = $('#geo_latitude').val();
		var long = $('#geo_longitude').val();
		if(lat.length>0) {
			geoMap(lat, long);
		} else if(address.length>0) {
			get_geo_map(address);
		}	
	}
}

function get_audio_val() {
	$('#audio_range_val').html($('#range-1b').val()+" Meters");
	$('#audio_range').val($('#range-1b').val());
	var address = $('#audio_fixed_point_address').val();
	var lat = $('#audio_latitude').val();
	var long = $('#audio_longitude').val();
	
	if(lat.length>0) {
		geoAudioMap(lat, long);
	} else if(address.length>0) {
		get_audio_map(address);
	}
}

function geoMap(lat, long) {
	
	var geocoder = new google.maps.Geocoder();
	var myLatlng = new google.maps.LatLng(lat, long);
	if($('#geo_fixed_point_address').val()!=null) {
		var address = $('#geo_fixed_point_address').val();
		if(address.length==0) {
			address = $('#def_address').val();		
		}

		var geo_range = $('#geo_range').val();

		var mapOptions = {
			center: new google.maps.LatLng(lat, long),
			zoom: 17,
			mapTypeId: google.maps.MapTypeId.HYBRID
		}
		var geo_map = new google.maps.Map(document.getElementById("geo_map"), mapOptions);

		var marker = new google.maps.Marker({
			position: myLatlng,
			map: geo_map,
			title: address
		});

		marker.setMap(geo_map);

		// Add circle overlay and bind to marker
		circle = new google.maps.Circle({
		  map: geo_map,
		  radius: parseInt(geo_range),
		  fillColor: '#98AFC7',
		  strokeColor: '#98AFC7',
		  strokeOpacity: 0.8,
		  fillOpacity: 0.8
		});
		circle.setMap(geo_map);
		circle.bindTo('center', marker, 'position');

		var infowindow = new google.maps.InfoWindow({
			content:address
		});

		//infowindow.open(geo_map,marker);

		document.getElementById('geo_map').style.display='block';

		google.maps.event.addListener(geo_map, "click", function(event) {

			geocoder.geocode({
				'latLng': event.latLng
			}, function(results, status) {
				if (status == google.maps.GeocoderStatus.OK) {
					if (results[0]) {
						$('#geo_fixed_point_address').val(results[0].formatted_address);


						// place a marker
						if (marker) { marker.setMap(null) }
						marker = new google.maps.Marker({ position: event.latLng, map: geo_map });		

						document.getElementById("geo_latitude").value= event.latLng.lat();
						document.getElementById("geo_longitude").value= event.latLng.lng();

						var infowindow = new google.maps.InfoWindow({
							content:results[0].formatted_address
						});

						remove_circle(circle);		

						circle = new google.maps.Circle({
							map: geo_map,
							radius: parseInt(geo_range),
							fillColor: '#98AFC7',
							strokeColor: '#98AFC7',
							strokeOpacity: 0.8,
							fillOpacity: 0.8,
							position: event.latLng
						});

						circle.bindTo('center', marker, 'position');

						//infowindow.open(geo_map,marker);					
					}
				}
			});
		});
	}
}
	

function geoAudioMap(lat, long) {
			
	var mapOptions = {
		center: new google.maps.LatLng(lat, long),
		zoom: 17,
		mapTypeId: google.maps.MapTypeId.HYBRID
	}
	var audio_map = new google.maps.Map(document.getElementById("audio_map"), mapOptions);

	var address = $('#audio_fixed_point_address').val();
	if(address.length==0) {
		address = $('#def_address').val();
	}

	var myLatlng = new google.maps.LatLng(lat,long);

	var geocoder = new google.maps.Geocoder();		

	var audio_range = $('#audio_range').val();

	var marker = new google.maps.Marker({
		position: myLatlng,
		map: audio_map,
		title: address
	});

	marker.setMap(audio_map);		

	// Add circle overlay and bind to marker
	audio_circle = new google.maps.Circle({
	  map: audio_map,
	  radius: parseInt(audio_range),
	  fillColor: '#98AFC7',
	  strokeColor: '#98AFC7',
	  strokeOpacity: 0.8,
	  fillOpacity: 0.8
	});
	audio_circle.setMap(audio_map);
	audio_circle.bindTo('center', marker, 'position');

	var infowindow = new google.maps.InfoWindow({
		content:address
	});

	audio_circle.bindTo('center', marker, 'position');

	//infowindow.open(audio_map,marker);

	var geocoder = new google.maps.Geocoder();

	google.maps.event.addListener(audio_map, "click", function(event) {

		var new_address = "";

		geocoder.geocode({
		'latLng': event.latLng
		}, function(results, status) {
			if (status == google.maps.GeocoderStatus.OK) {
				if (results[0]) {

					$('#audio_fixed_point_address').val(results[0].formatted_address);						
					new_address = results[0].formatted_address;

					// place a marker
					if (marker) { marker.setMap(null) }
					marker = new google.maps.Marker({ position: event.latLng, map: audio_map, title: new_address });

					$('#audio_latitude').val(event.latLng.lat());
					$('#audio_longitude').val(event.latLng.lng());						

					var infowindow = new google.maps.InfoWindow({
						content:new_address
					});

					remove_audio_circle(audio_circle);

					audio_circle = new google.maps.Circle({
						map: audio_map,
						radius: parseInt(audio_range),
						fillColor: '#98AFC7',
						strokeColor: '#98AFC7',
						strokeOpacity: 0.8,
						fillOpacity: 0.8,
						position: event.latLng
					});

					audio_circle.bindTo('center', marker, 'position');

					//infowindow.open(audio_map,marker);

				}
			}
		});		   
	});		
	   
}


var circle;
var geo_map;
function get_geo_map(address) {	
	
	var geo_range = $('#geo_range').val();

	$.ajax({url:"./ajax/ajax.php?address="+address+"&action=getlocation",success:function(result){

	var array = result.split(',');	
		
	if(array[1]==''){
		alert("Unable to find your location");		
		$('#geo_map').show();		
	} else {
		
		$('#geo_latitude').val(array[0]);
		$('#geo_longitude').val(array[1]);
					
		//function initialize() {
  		var mapOptions = {
    		zoom: 17,
    		center: new google.maps.LatLng(array[0], array[1])
  		};
  		
		geo_map = new google.maps.Map(document.getElementById('geo_map'), mapOptions);
				
		var myLatlng = new google.maps.LatLng(array[0],array[1]);
		
		var marker = new google.maps.Marker({
			position: myLatlng,
			map: geo_map,
			title: address
		});
				 
		marker.setMap(geo_map);
			
		// Add circle overlay and bind to marker
		circle = new google.maps.Circle({
		  map: geo_map,
		  radius: parseInt(geo_range),
		  fillColor: '#98AFC7',
		  strokeColor: '#98AFC7',
		  strokeOpacity: 0.8,
		  fillOpacity: 0.8
		});
		circle.setMap(geo_map);
		circle.bindTo('center', marker, 'position');
				
		var geocoder = new google.maps.Geocoder();
		
		google.maps.event.addListener(geo_map, "click", function(event) {
			
			geocoder.geocode({
				'latLng': event.latLng
			}, function(results, status) {
				if (status == google.maps.GeocoderStatus.OK) {
					if (results[0]) {
						$('#geo_fixed_point_address').val(results[0].formatted_address);
				  	}
				}
			});
			
			// place a marker
           	if (marker) { marker.setMap(null) }
		   	marker = new google.maps.Marker({ position: event.latLng, map: geo_map });		
			
		   	document.getElementById("geo_latitude").value= event.latLng.lat();
			document.getElementById("geo_longitude").value= event.latLng.lng();
					   
		   	var infowindow = new google.maps.InfoWindow({
				content:address
			});
			
			remove_circle(circle);		
			
			circle = new google.maps.Circle({
				map: geo_map,
				radius: parseInt(geo_range),
				fillColor: '#98AFC7',
				strokeColor: '#98AFC7',
				strokeOpacity: 0.8,
				fillOpacity: 0.8,
				position: event.latLng
			});
					
			circle.bindTo('center', marker, 'position');
						
			//infowindow.open(geo_map,marker);
		   
		});
		
		var infowindow = new google.maps.InfoWindow({
			content:address
  		});

		//infowindow.open(geo_map,marker);

 		document.getElementById('geo_map').style.display='block';

		}
	}});
}

function remove_circle(circle) {	
    // remove event listers
    google.maps.event.clearListeners(circle, 'click_handler_name');
    google.maps.event.clearListeners(circle, 'drag_handler_name');
    circle.setRadius(0);    
    circle.setMap(null);
}

function remove_audio_circle(audio_circle) {	
    // remove event listers
    google.maps.event.clearListeners(audio_circle, 'click_handler_name');
    google.maps.event.clearListeners(audio_circle, 'drag_handler_name');
    audio_circle.setRadius(0);     
    audio_circle.setMap(null);
}

var audio_circle;
var audio_map;
function get_audio_map(address) {
	
	var audio_range = $('#audio_range').val();	
	
	$.ajax({url:"./ajax/ajax.php?address="+address+"&action=getlocation",success:function(result){
		
		var array = result.split(',');
		
		if(array[1]==''){
			alert("Unable to find your location");
			$('#audio_map').show();
		} else {
			
			$('#audio_latitude').val(array[0]);
			$('#audio_longitude').val(array[1]);
			
			var mapOptions = {
				zoom: 17,
				center: new google.maps.LatLng(array[0], array[1])
  			};
			
			audio_map = new google.maps.Map(document.getElementById('audio_map'), mapOptions);
			
			var myLatlng = new google.maps.LatLng(array[0],array[1]);
			
			var marker = new google.maps.Marker({
				position: myLatlng,
				map: audio_map,
				title: address
			});
				 
			marker.setMap(audio_map);
		
			// Add circle overlay and bind to marker
			audio_circle = new google.maps.Circle({
				map: audio_map,
				radius: parseInt(audio_range),
				fillColor: '#98AFC7',
				strokeColor: '#98AFC7',
				strokeOpacity: 0.8,
				fillOpacity: 0.8
			});
			audio_circle.setMap(audio_map);
			audio_circle.bindTo('center', marker, 'position');
			
			var geocoder = new google.maps.Geocoder();
			
			google.maps.event.addListener(audio_map, "click", function(event) {
				
				geocoder.geocode({
				'latLng': event.latLng
				}, function(results, status) {
					if (status == google.maps.GeocoderStatus.OK) {
						if (results[0]) {
							$('#audio_fixed_point_address').val(results[0].formatted_address);
						}
					}
				});

				// place a marker
				if (marker) { marker.setMap(null) }
					marker = new google.maps.Marker({ position: event.latLng, map: audio_map });
											
		   		document.getElementById("audio_latitude").value= event.latLng.lat();
				document.getElementById("audio_longitude").value= event.latLng.lng();
					   
		   		var infowindow = new google.maps.InfoWindow({
					content:address
				});
			
				remove_audio_circle(audio_circle);
			
				audio_circle = new google.maps.Circle({
					map: audio_map,
					radius: parseInt(audio_range),
					fillColor: '#98AFC7',
					strokeColor: '#98AFC7',
					strokeOpacity: 0.8,
					fillOpacity: 0.8,
					position: event.latLng
				});
					
				audio_circle.bindTo('center', marker, 'position');
						
				//infowindow.open(audio_map,marker);
		   
			});

			var infowindow = new google.maps.InfoWindow({
				content:address
  			});
				
			//infowindow.open(audio_map,marker);
		
  			document.getElementById('audio_map').style.display='block';	            
		}
	}});
}