<?php
session_start();
/* 
 *	This is the main admin page.
 *	This page includes the configuration file, 
 *	the templates, and any content-specific modules.
 */

// Require the configuration file before any PHP code:
require_once ('../config/config.inc.php');

//date_default_timezone_set('UTC'); 


// Validate what page to show:
if (isset($_GET['page'])) {
	$page = $_GET['page'];
} elseif (isset($_POST['page'])) { // Forms
	$page = $_POST['page'];
} else {
	$page = 'home';
}



$pageArray = array('home', 'login', 'change_pass', 'logout', 'settings', 'adminManagement', 'access_control',
				   'forgot_password', 'manage_coupons', 'add_coupon', 'massmail', 'add_staff', 'manage_staff',
				   'add_salary', 'salary_report', 'add_advance', 'advance_report', 'add_leave', 'leave_report',
				   'access_control', 'settings', 'add_admin', 'manage_admin', 'view_staff', 'add_user', 'manage_user',
				   'manage_user_tasks', 'view_user', 'massmail', 'send_mail', 'user_payments', 'add_location', 'manage_location',
				   'add_category','manage_category', 'add_purchase_partner','manage_purchase_partner','add_product_category',
				   'manage_product_category','add_product','manage_product', 'view_purchase_partner','manage_purchase_order',
				   'add_purchase_order','view_purchase_order','add_technician','manage_technician','view_technician',			   'technician_category','technician_add_category','technician_profile','technician_availability',
				   'technician_transaction','technician_reviews','add_salary_advance','shop_assign_category',
				   'order_assign_shops','add_technician_payment','technician_payments', 'user_gods_view',				   'technician_gods_view','make_operator','task_assign_technician','view_task','category_charge',
				   'add_project','manage_projects','static','view_project','project_add_income',
				   'project_add_expense','project_expenses','project_incomes','add_task_type','add_sub_task',
				   'tech_sub_commission','project_profit_loss','admin_login','tech_disputes','user_disputes',
				   'tech_payments','tech_incomes','tech_add_payment', 'tech_add_income','user_feedbacks','tech_leads',
				   'operator_location','tech_transactions','tech_location','shop_gods_view', 'purchase_partner_photos',			   'add_overtime','overtime_report','tech_reviews','user_reviews','add_coupon','manage_coupons',
				   'view_task_project','tech_extra_tech_requests','user_payments', 'user_tasks','purchase_commission',
				   'purchase_incomes', 'shop_add_income','task_gods_view','change_password',
				   'tech_accounts','expense_category', 'add_expense','manage_expenses','profit_loss',
				   'add_credit','user_deposits','tech_bookings','profit_loss_project','sub_tech_incomes',
				   'referral_report','create_task','send_push_user','send_push_tech','send_push_shop',
				   'send_mass_push','mass_push','subscribers','shop_customer_purchases','mass_sms',				   'availability_updates','send_sms_user','user_add_credit','tech_add_credit','holidays',
				   'add_holiday','tech_paid_report','shop_paid_report','tech_to_admin_payments', 			   'admin_to_tech_payments','shop_to_admin_payments','sales_report_task', 'sales_report_user',
				   'income_category','add_income', 'manage_incomes','manage_ivrs', 'tech_leads_edit','massmail_report','massmail_details','change_commission','add_leads','leads_note',
				  'configuration');


if(!in_array($page, $pageArray)) {
	$page = 'home';		
} 


// Include database connection
require_once (DB);

setlocale(LC_MONETARY, 'en_IN');
$adminLabel = 'OnDemand PRO';



if($page != 'login' && $page!='forgot_password') {
	require_once ('./includes/authenticate.php');
}


//get unread counts (count of user, tech ... not viewed by admin)
$unreadTechRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_technician WHERE viewed != 'yes'"));
$unreadTechCount = $unreadTechRec['count'];
$unreadUserRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_user WHERE viewed != 'yes'"));
$unreadUserCount = $unreadUserRec['count'];
$unreadShopRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_purchase_partner WHERE viewed != 'yes'"));
$unreadShopCount = $unreadShopRec['count'];
$unreadTaskRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE viewed != 'yes'"));
$unreadTaskCount = $unreadTaskRec['count'];
//$unreadOrdersRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_purchase_order WHERE viewed != 'yes'"));
$unreadOrdersRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_purchase_order WHERE partner_id = '0' AND status = 'new'"));
$unreadOrderCount = $unreadOrdersRec['count'];
$unassignedExtraTechRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM `tbl_job_extra_tech` WHERE `technician_id` = '0'"));
$unassignedExtraTechCount = $unassignedExtraTechRec['count'];

$pageVars = '';

// Include the module php file:
require_once ('./modules/app/' . $page . '.php');

//get footer copyright
$footerSettingsRec = mysqli_fetch_array(mysqli_query($con, "SELECT copyright, logo FROM tbl_settings WHERE id = '1'"));

// Include the header file:
if($page == 'login' || $page=='forgot_password') {
	require_once ('./includes/header_login.php');
} else {
	$notifyCount = 0;	
	//checking for notifications
	$notifyTaskRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job WHERE viewed != 'yes'"));
	$notifyTaskCount = $notifyTaskRec['count'];	
	//get new task not yet viewed by admin
	// $notifyTaskRs = mysqli_query($con, "SELECT id, is_project, user_id, date FROM tbl_job WHERE status = 'New' AND viewed != 'yes' ORDER BY id DESC LIMIT 50");
	//get new user notifications
	$notifyUserRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_user WHERE viewed != 'yes'"));
	$notifyUserCount = $notifyUserRec['count'];
	//$notifyUserRs = mysqli_query($con, "SELECT id, name, date FROM tbl_user WHERE viewed != 'yes' ORDER BY id DESC LIMIT 10");
	//get new tech notifications
	$notifyTechRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_technician WHERE viewed != 'yes'"));
	$notifyTechCount = $notifyTechRec['count'];
	//$notifyTechRs = mysqli_query($con, "SELECT id, name, date FROM tbl_technician WHERE viewed != 'yes' ORDER BY id DESC LIMIT 10");
	//get new PP notifications
	$notifyPPRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_purchase_partner WHERE viewed != 'yes'"));
	$notifyPPCount = $notifyPPRec['count'];
	//$notifyPPRs = mysqli_query($con, "SELECT id, name, date FROM tbl_purchase_partner WHERE viewed != 'yes' ORDER BY id DESC LIMIT 10");
	//get new PP orders
	$notifyOrderRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_purchase_order WHERE status = 'new' AND partner_id = '0'"));
	$notifyOrderCount = $notifyOrderRec['count'];
	//$notifyOrderRs = mysqli_query($con, "SELECT id, technician_id, date FROM tbl_purchase_order WHERE viewed != 'yes' ORDER BY id DESC LIMIT 10");
	//extra tech requests
	$notifyExtraTechRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job_extra_tech WHERE technician_id = '0' AND status = ''"));
	$notifyExtraTechCount = $notifyExtraTechRec['count'];
	//$notifyExtraTechRs = mysqli_query($con, "SELECT id, job_id, tech_main_id, date FROM tbl_job_extra_tech WHERE technician_id = '0' AND status = '' ORDER BY id DESC LIMIT 20");
	$notifyDisputeRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_job_disputes WHERE status = ''"));
	$notifyDisputeCount = $notifyDisputeRec['count'];
	$notifyCatReqRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_technician_category WHERE verified = ''"));
	$notifyCatReqCount = $notifyCatReqRec['count'];
	$notifyLeadsRec = mysqli_fetch_array(mysqli_query($con, "SELECT count(id) AS count FROM tbl_new_leads WHERE status = 'New'"));
	$notifyLeadsCount = $notifyLeadsRec['count'];
		
	$notifyCount = $notifyTaskCount+$notifyUserCount+$notifyTechCount+$notifyPPCount+$notifyOrderCount+$notifyExtraTechCount+$notifyDisputeCount+
	$notifyCatReqCount+$notifyLeadsCount;
	
	
	require_once ('./includes/header_dyn.php');	
	
}

//echo $page;
// Include the module html file:
require_once ('./modules/html/' . $page . '.html.php');

// Include the footer file:
if($page != 'login' || $page!='forgot_password') {
	require_once ('./includes/footer.php');
} else {
	require_once ('./includes/footer_login.php');
}
?>